#ifndef CVENUMS_h
#define CVENUMS_h

// enums.h

#include "CvDefines.h"

enum DllExport GameStateTypes					// Exposed to Python
{
	GAMESTATE_ON,
	GAMESTATE_OVER,
	GAMESTATE_EXTENDED,
};

enum DllExport PopupStates						// Exposed to Python
{
	POPUPSTATE_IMMEDIATE,
	POPUPSTATE_QUEUED,
	POPUPSTATE_MINIMIZED,
};

enum DllExport PopupEventTypes
{
	POPUPEVENT_NONE,
	POPUPEVENT_PRODUCTION,
	POPUPEVENT_TECHNOLOGY,
	POPUPEVENT_RELIGION,
	POPUPEVENT_WARNING,
	POPUPEVENT_CIVIC,
};

enum DllExport CameraLookAtTypes			// Exposed to Python
{
	CAMERALOOKAT_NORMAL,
	CAMERALOOKAT_CITY_ZOOM_IN,
	CAMERALOOKAT_BATTLE,
	CAMERALOOKAT_BATTLE_ZOOM_IN,
	CAMERALOOKAT_SHRINE_ZOOM_IN,
	CAMERALOOKAT_IMMEDIATE,
	CAMERALOOKAT_HOTSEAT,
};

enum DllExport CameraMovementSpeeds		// Exposed to Python
{
	CAMERAMOVEMENTSPEED_NORMAL,
	CAMERAMOVEMENTSPEED_SLOW,
	CAMERAMOVEMENTSPEED_FAST,
};

enum DllExport CameraAnimationTypes
{
	NO_CAMERA_ANIMATION = -1,
};

enum DllExport ZoomLevelTypes					// Exposed to Python
{
	ZOOM_UNKNOWN							= 0x00000000,
	ZOOM_DETAIL								= 0x00000001,
	ZOOM_NORMAL								= 0x00000002,
	ZOOM_GLOBEVIEW_TRANSITION	= 0x00000004,
	ZOOM_GLOBEVIEW						= 0x00000008
};

enum DllExport DirectionTypes					// Exposed to Python
{
	NO_DIRECTION = -1,

	DIRECTION_NORTH,
	DIRECTION_NORTHEAST,
	DIRECTION_EAST,
	DIRECTION_SOUTHEAST,
	DIRECTION_SOUTH,
	DIRECTION_SOUTHWEST,
	DIRECTION_WEST,
	DIRECTION_NORTHWEST,

	NUM_DIRECTION_TYPES
};

enum DllExport CardinalDirectionTypes			// Exposed to Python
{
	NO_CARDINALDIRECTION = -1,

	CARDINALDIRECTION_NORTH,
	CARDINALDIRECTION_EAST,
	CARDINALDIRECTION_SOUTH,
	CARDINALDIRECTION_WEST,

	NUM_CARDINALDIRECTION_TYPES
};

enum DllExport RotationTypes
{
	ROTATE_NONE = 0,
	ROTATE_90CW,
	ROTATE_180CW,
	ROTATE_270CW,
	NUM_ROTATION_TYPES,

	ROTATE_NONE_MASK	= 1 << ROTATE_NONE,
	ROTATE_90CW_MASK	= 1 << ROTATE_90CW,
	ROTATE_180CW_MASK	= 1 << ROTATE_180CW,
	ROTATE_270CW_MASK	= 1 << ROTATE_270CW,
};

// camera wrap helper
enum DllExport WrapDirection
{
	WRAP_SAVE,
	WRAP_NONE = WRAP_SAVE,
	WRAP_RESTORE,
	WRAP_LEFT,
	WRAP_RIGHT,
	WRAP_UP,
	WRAP_DOWN,
	NUM_WRAP_DIRECTIONS
};

enum DllExport ColorTypes						// Exposed to Python
{
	NO_COLOR = -1,
};

enum DllExport PlayerColorTypes			// Exposed to Python
{
	NO_PLAYERCOLOR = -1,
};

//Warning: these values correspond to locations in the plot texture [JW]
enum DllExport PlotStyles						// Exposed to Python
{
	PLOT_STYLE_NONE = -1,

	//first row
	PLOT_STYLE_NUMPAD_1 = 0,
	PLOT_STYLE_NUMPAD_2,
	PLOT_STYLE_NUMPAD_3,
	PLOT_STYLE_NUMPAD_4,
	PLOT_STYLE_NUMPAD_6,
	PLOT_STYLE_NUMPAD_7,
	PLOT_STYLE_NUMPAD_8,
	PLOT_STYLE_NUMPAD_9,

	//second row
	PLOT_STYLE_NUMPAD_1_ANGLED = 8,
	PLOT_STYLE_NUMPAD_2_ANGLED,
	PLOT_STYLE_NUMPAD_3_ANGLED,
	PLOT_STYLE_NUMPAD_4_ANGLED,
	PLOT_STYLE_NUMPAD_6_ANGLED,
	PLOT_STYLE_NUMPAD_7_ANGLED,
	PLOT_STYLE_NUMPAD_8_ANGLED,
	PLOT_STYLE_NUMPAD_9_ANGLED,

	//third row
	PLOT_STYLE_BOX_FILL = 16,
	PLOT_STYLE_BOX_OUTLINE,
	PLOT_STYLE_RIVER_SOUTH,
	PLOT_STYLE_RIVER_EAST,
	PLOT_STYLE_SIDE_ARROWS,
	PLOT_STYLE_CIRCLE,
	PLOT_STYLE_TARGET,
	PLOT_STYLE_DOT_TARGET,

	//fourth row
	PLOT_STYLE_WAVES = 24,
	PLOT_STYLE_DOTS,
	PLOT_STYLE_CIRCLES,
};

//Warning: these values are used as an index into a fixed array
enum DllExport PlotLandscapeLayers		// Exposed to Python
{
	PLOT_LANDSCAPE_LAYER_ALL = -1,
	PLOT_LANDSCAPE_LAYER_BASE = 0,
	PLOT_LANDSCAPE_LAYER_RECOMMENDED_PLOTS = 1,
	PLOT_LANDSCAPE_LAYER_WORLD_BUILDER = 2,
	PLOT_LANDSCAPE_LAYER_NUMPAD_HELP = 2,
	PLOT_LANDSCAPE_LAYER_HIGHLIGHT_PLOTS = 2,
	PLOT_LANDSCAPE_LAYER_REVEALED_PLOTS = 1,
};

enum DllExport EffectTypes
{
	NO_EFFECT = -1,
};

enum DllExport AttachableTypes
{
	NO_ATTACHABLE = -1,
};

enum DllExport InterfaceModeTypes			// Exposed to Python
{
	NO_INTERFACEMODE = -1,

	INTERFACEMODE_SELECTION,
	INTERFACEMODE_PING,
	INTERFACEMODE_SIGN,
	INTERFACEMODE_GRIP,
	INTERFACEMODE_GLOBELAYER_INPUT,
	INTERFACEMODE_GO_TO,
	INTERFACEMODE_GO_TO_TYPE,
	INTERFACEMODE_GO_TO_ALL,
	INTERFACEMODE_ROUTE_TO,
	INTERFACEMODE_AIRLIFT,
	INTERFACEMODE_NUKE,
	INTERFACEMODE_RECON,
	INTERFACEMODE_AIRBOMB,
	INTERFACEMODE_AIRSTRIKE,
	INTERFACEMODE_REBASE,

	NUM_INTERFACEMODE_TYPES
};

enum DllExport InterfaceMessageTypes	// Exposed to Python
{
	NO_MESSAGE_TYPE = -1,

	MESSAGE_TYPE_INFO,
	MESSAGE_TYPE_DISPLAY_ONLY,
	MESSAGE_TYPE_MAJOR_EVENT,
	MESSAGE_TYPE_MINOR_EVENT,
	MESSAGE_TYPE_CHAT,
	MESSAGE_TYPE_COMBAT_MESSAGE,

	NUM_INTERFACE_MESSAGE_TYPES
};

enum DllExport FlyoutTypes
{
	NO_FLYOUT = -1,

	FLYOUT_HURRY,
	FLYOUT_CONSCRIPT,
	FLYOUT_TRAIN,
	FLYOUT_CONSTRUCT,
	FLYOUT_CREATE,
	FLYOUT_MAINTAIN,
	FLYOUT_MOVE_TO,
	FLYOUT_SELECT_UNIT,
	FLYOUT_SELECT_ALL,
	FLYOUT_WAKE_ALL,
	FLYOUR_FORTIFY_ALL,
	FLYOUR_SLEEP_ALL,
};

enum DllExport MinimapModeTypes		// Exposed to Python
{
	NO_MINIMAPMODE = -1,

	MINIMAPMODE_TERRITORY,
	MINIMAPMODE_TERRAIN,
	MINIMAPMODE_REPLAY,
	MINIMAPMODE_MILITARY,

	NUM_MINIMAPMODE_TYPES
};

enum DllExport EngineDirtyBits		// Exposed to Python
{
	GlobeTexture_DIRTY_BIT,
	GlobePartialTexture_DIRTY_BIT,
	MinimapTexture_DIRTY_BIT,
	FogOfWar_DIRTY_BIT,
	CultureBorders_DIRTY_BIT,

	NUM_ENGINE_DIRTY_BITS
};

enum DllExport InterfaceDirtyBits // Exposed to Python
{
	SelectionCamera_DIRTY_BIT,
	Fog_DIRTY_BIT,
	GlobeLayer_DIRTY_BIT,
	GlobeInfo_DIRTY_BIT,
	Waypoints_DIRTY_BIT,
	PercentButtons_DIRTY_BIT,
	MiscButtons_DIRTY_BIT,
	PlotListButtons_DIRTY_BIT,
	SelectionButtons_DIRTY_BIT,
	CitizenButtons_DIRTY_BIT,
	ResearchButtons_DIRTY_BIT,
	Event_DIRTY_BIT,
	Center_DIRTY_BIT,
	GameData_DIRTY_BIT,
	Score_DIRTY_BIT,
	TurnTimer_DIRTY_BIT,
	Help_DIRTY_BIT,
	MinimapSection_DIRTY_BIT,
	SelectionSound_DIRTY_BIT,
	Cursor_DIRTY_BIT,
	CityInfo_DIRTY_BIT,
	UnitInfo_DIRTY_BIT,
	Popup_DIRTY_BIT,
	CityScreen_DIRTY_BIT,
	InfoPane_DIRTY_BIT,
	Flag_DIRTY_BIT,
	HighlightPlot_DIRTY_BIT,
	ColoredPlots_DIRTY_BIT,
	Financial_Screen_DIRTY_BIT,
	Foreign_Screen_DIRTY_BIT,
	Soundtrack_DIRTY_BIT,
	Domestic_Advisor_DIRTY_BIT,

	NUM_INTERFACE_DIRTY_BITS
};

enum DllExport CityTabTypes			// Exposed to Python
{
	NO_CITYTAB = -1,

	CITYTAB_UNITS,
	CITYTAB_BUILDINGS,
	CITYTAB_WONDERS,

	NUM_CITYTAB_TYPES
};

enum DllExport WidgetTypes					// Exposed to Python
{
	WIDGET_PLOT_LIST,
	WIDGET_PLOT_LIST_SHIFT,
	WIDGET_CITY_SCROLL,
	WIDGET_CITY_NAME,
	WIDGET_UNIT_NAME,
	WIDGET_CREATE_GROUP,
	WIDGET_DELETE_GROUP,
	WIDGET_TRAIN,
	WIDGET_CONSTRUCT,
	WIDGET_CREATE,
	WIDGET_MAINTAIN,
	WIDGET_HURRY,
	WIDGET_MENU_ICON,
	WIDGET_CONSCRIPT,
	WIDGET_ACTION,
	WIDGET_DISABLED_CITIZEN,
	WIDGET_CITIZEN,
	WIDGET_ANGRY_CITIZEN,
	WIDGET_CHANGE_SPECIALIST,
	WIDGET_RESEARCH,
	WIDGET_TECH_TREE,
	WIDGET_CHANGE_PERCENT,
	WIDGET_CITY_TAB,
	WIDGET_CONTACT_CIV,
	WIDGET_SCORE_BREAKDOWN,
	WIDGET_ZOOM_CITY,
	WIDGET_END_TURN,
	WIDGET_CONVERT,
	WIDGET_AUTOMATE_CITIZENS,
	WIDGET_AUTOMATE_PRODUCTION,
	WIDGET_EMPHASIZE,
	WIDGET_DIPLOMACY_RESPONSE,
	WIDGET_GENERAL,
	WIDGET_FILE_LISTBOX,
	WIDGET_FILE_EDITBOX,
	WIDGET_WB_UNITNAME_EDITBOX,
	WIDGET_WB_CITYNAME_EDITBOX,
	WIDGET_WB_SAVE_BUTTON,
	WIDGET_WB_LOAD_BUTTON,
	WIDGET_WB_ALL_PLOTS_BUTTON,
	WIDGET_WB_LANDMARK_BUTTON,
	WIDGET_WB_ERASE_BUTTON,
	WIDGET_WB_EXIT_BUTTON,
	WIDGET_WB_UNIT_EDIT_BUTTON,
	WIDGET_WB_CITY_EDIT_BUTTON,
	WIDGET_WB_NORMAL_PLAYER_TAB_MODE_BUTTON,
	WIDGET_WB_NORMAL_MAP_TAB_MODE_BUTTON,
	WIDGET_WB_REVEAL_TAB_MODE_BUTTON,
	WIDGET_WB_DIPLOMACY_MODE_BUTTON,
	WIDGET_WB_REVEAL_ALL_BUTTON,
	WIDGET_WB_UNREVEAL_ALL_BUTTON,
	WIDGET_WB_REGENERATE_MAP,
	WIDGET_TRADE_ITEM,
	WIDGET_UNIT_MODEL,
	WIDGET_FLAG,
	WIDGET_LIGHT_DEBUG_SPINNER,
	WIDGET_POPUP_QUEUE,

	//	This is meant for python buttons, it will call python functions for display and execution
	WIDGET_PYTHON,

	//	This button type is reserved for widgets meant to be displayed only.  This is meant for general interface text and such...
	WIDGET_HELP_MAINTENANCE,
	WIDGET_HELP_RELIGION,
	WIDGET_HELP_RELIGION_CITY,
	WIDGET_HELP_NATIONALITY,
	WIDGET_HELP_DEFENSE,
	WIDGET_HELP_HEALTH,
	WIDGET_HELP_HAPPINESS,
	WIDGET_HELP_POPULATION,
	WIDGET_HELP_PRODUCTION,
	WIDGET_HELP_CULTURE,
	WIDGET_HELP_GREAT_PEOPLE,
	WIDGET_HELP_SELECTED,
	WIDGET_HELP_BUILDING,
	WIDGET_HELP_TECH_ENTRY,
	WIDGET_HELP_TECH_PREPREQ,
	WIDGET_HELP_OBSOLETE,
	WIDGET_HELP_OBSOLETE_BONUS,
	WIDGET_HELP_OBSOLETE_SPECIAL,
	WIDGET_HELP_MOVE_BONUS,
	WIDGET_HELP_FREE_UNIT,
	WIDGET_HELP_FEATURE_PRODUCTION,
	WIDGET_HELP_WORKER_RATE,
	WIDGET_HELP_TRADE_ROUTES,
	WIDGET_HELP_HEALTH_RATE,
	WIDGET_HELP_HAPPINESS_RATE,
	WIDGET_HELP_FREE_TECH,
	WIDGET_HELP_LOS_BONUS,
	WIDGET_HELP_MAP_CENTER,
	WIDGET_HELP_MAP_REVEAL,
	WIDGET_HELP_MAP_TRADE,
	WIDGET_HELP_TECH_TRADE,
	WIDGET_HELP_GOLD_TRADE,
	WIDGET_HELP_OPEN_BORDERS,
	WIDGET_HELP_DEFENSIVE_PACT,
	WIDGET_HELP_PERMANENT_ALLIANCE,
	WIDGET_HELP_BUILD_BRIDGE,
	WIDGET_HELP_IRRIGATION,
	WIDGET_HELP_IGNORE_IRRIGATION,
	WIDGET_HELP_WATER_WORK,
	WIDGET_HELP_IMPROVEMENT,
	WIDGET_HELP_DOMAIN_EXTRA_MOVES,
	WIDGET_HELP_ADJUST,
	WIDGET_HELP_TERRAIN_TRADE,
	WIDGET_HELP_SPECIAL_BUILDING,
	WIDGET_HELP_YIELD_CHANGE,
	WIDGET_HELP_BONUS_REVEAL,
	WIDGET_HELP_CIVIC_REVEAL,
	WIDGET_HELP_PROCESS_INFO,
	WIDGET_HELP_FOUND_RELIGION,
	WIDGET_HELP_FINANCE_NUM_UNITS,
	WIDGET_HELP_FINANCE_UNIT_COST,
	WIDGET_HELP_FINANCE_AWAY_SUPPLY,
	WIDGET_HELP_FINANCE_CITY_MAINT,
	WIDGET_HELP_FINANCE_CIVIC_UPKEEP,
	WIDGET_HELP_FINANCE_FOREIGN_INCOME,
	WIDGET_HELP_FINANCE_INFLATED_COSTS,
	WIDGET_HELP_FINANCE_GROSS_INCOME,
	WIDGET_HELP_FINANCE_NET_GOLD,
	WIDGET_HELP_FINANCE_GOLD_RESERVE,

	WIDGET_PEDIA_JUMP_TO_TECH,
	WIDGET_PEDIA_JUMP_TO_UNIT,
	WIDGET_PEDIA_JUMP_TO_BUILDING,
	WIDGET_PEDIA_JUMP_TO_REQUIRED_TECH,
	WIDGET_PEDIA_JUMP_TO_DERIVED_TECH,
	WIDGET_PEDIA_BACK,
	WIDGET_PEDIA_FORWARD,
	WIDGET_PEDIA_JUMP_TO_BONUS,
	WIDGET_PEDIA_MAIN,
	WIDGET_PEDIA_JUMP_TO_PROMOTION,
	WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT,
	WIDGET_PEDIA_JUMP_TO_IMPROVEMENT,
	WIDGET_PEDIA_JUMP_TO_CIVIC,
	WIDGET_PEDIA_JUMP_TO_CIV,
	WIDGET_PEDIA_JUMP_TO_LEADER,
	WIDGET_PEDIA_JUMP_TO_SPECIALIST,
	WIDGET_PEDIA_JUMP_TO_PROJECT,
	WIDGET_PEDIA_JUMP_TO_TERRAIN,
	WIDGET_PEDIA_JUMP_TO_FEATURE,
	WIDGET_TURN_EVENT,
	WIDGET_FOREIGN_ADVISOR,
	WIDGET_REVOLUTION,
	WIDGET_PEDIA_DESCRIPTION,
	WIDGET_PEDIA_DESCRIPTION_NO_HELP,
	WIDGET_DEAL_KILL,
	WIDGET_MINIMAP_HIGHLIGHT,
	WIDGET_PRODUCTION_MOD_HELP,
	WIDGET_LEADERHEAD,
	WIDGET_LEADER_LINE,
	WIDGET_COMMERCE_MOD_HELP,
	WIDGET_CLOSE_SCREEN,
	WIDGET_PEDIA_JUMP_TO_RELIGION,
	WIDGET_GLOBELAYER,
	WIDGET_GLOBELAYER_OPTION,
	WIDGET_GLOBELAYER_TOGGLE,

	NUM_WIDGET_TYPES
};

enum DllExport ButtonPopupTypes			// Exposed to Python
{
	BUTTONPOPUP_TEXT,
	BUTTONPOPUP_MAIN_MENU,
	BUTTONPOPUP_CONFIRM_MENU,
	BUTTONPOPUP_DECLAREWARMOVE,
	BUTTONPOPUP_CONFIRMCOMMAND,
	BUTTONPOPUP_LOADUNIT,
	BUTTONPOPUP_CHOOSETECH,
	BUTTONPOPUP_RAZECITY,
	BUTTONPOPUP_DISBANDCITY,
	BUTTONPOPUP_CHOOSEPRODUCTION,
	BUTTONPOPUP_CHANGECIVIC,
	BUTTONPOPUP_CHANGERELIGION,
	BUTTONPOPUP_CHOOSEELECTION,
	BUTTONPOPUP_DIPLOVOTE,
	BUTTONPOPUP_DIPLOVOTE_RESULTS,
	BUTTONPOPUP_ALARM,
	BUTTONPOPUP_DEAL_CANCELED,
	BUTTONPOPUP_PYTHON,
	BUTTONPOPUP_PYTHON_SCREEN,
	BUTTONPOPUP_DETAILS,
	BUTTONPOPUP_ADMIN,
	BUTTONPOPUP_ADMIN_PASSWORD,
	BUTTONPOPUP_EXTENDED_GAME,
	BUTTONPOPUP_DIPLOMACY,
	BUTTONPOPUP_ADDBUDDY,
	BUTTONPOPUP_FORCED_DISCONNECT,
	BUTTONPOPUP_PITBOSS_DISCONNECT,
	BUTTONPOPUP_KICKED,

	NUM_BUTTONPOPUP_TYPES
};

enum DllExport ClimateTypes					// Exposed to Python
{
	NO_CLIMATE = -1,
};

enum DllExport SeaLevelTypes				// Exposed to Python
{
	NO_SEALEVEL = -1,
};

enum DllExport CustomMapOptionTypes	// Exposed to Python
{
	NO_CUSTOM_MAPOPTION = -1,
};

enum DllExport WorldSizeTypes				// Exposed to Python
{
	NO_WORLDSIZE = -1,

	WORLDSIZE_DUEL,
	WORLDSIZE_TINY,
	WORLDSIZE_SMALL,
	WORLDSIZE_STANDARD,
	WORLDSIZE_LARGE,
	WORLDSIZE_HUGE,

	NUM_WORLDSIZE_TYPES
};

// This is our current relationship with each 
// one of our connected network peers
enum DllExport InitStates
{
	INIT_INACTIVE,
	INIT_CONNECTED,
	INIT_SENT_READY,
	INIT_READY,
	INIT_ASSIGNED_ID,
	INIT_SENT_ID,
	INIT_PEER,
	INIT_FILE_TRANSFER,
	INIT_TRANSFER_COMPLETE,
	INIT_AUTHORIZED,
	INIT_MAP_CONFIRMED,
	INIT_GAME_STARTED,
};

enum DllExport TerrainTypes						// Exposed to Python
{
	NO_TERRAIN = -1,
};

enum DllExport PlotTypes							// Exposed to Python
{
	NO_PLOT = -1,

	PLOT_PEAK,
	PLOT_HILLS,
	PLOT_LAND,
	PLOT_OCEAN,

	NUM_PLOT_TYPES,
};

enum DllExport YieldTypes							// Exposed to Python
{
	NO_YIELD = -1,

	YIELD_FOOD,
	YIELD_PRODUCTION,
	YIELD_COMMERCE,

	NUM_YIELD_TYPES
};

enum DllExport CommerceTypes					// Exposed to Python
{
	NO_COMMERCE = -1,

	COMMERCE_GOLD,
	COMMERCE_RESEARCH,
	COMMERCE_CULTURE,

	NUM_COMMERCE_TYPES
};

enum DllExport AdvisorTypes						// Exposed to Python
{
	NO_ADVISOR = -1
};

enum DllExport FlavorTypes						// Exposed to Python
{
	NO_FLAVOR = -1
};

enum DllExport EmphasizeTypes					// Exposed to Python
{
	NO_EMPHASIZE = -1,
};

enum DllExport GameOptionTypes				// Exposed to Python
{
	NO_GAMEOPTION = -1,

	GAMEOPTION_NO_CITY_RAZING,
	GAMEOPTION_NO_CITY_FLIPPING,
	GAMEOPTION_FLIPPING_AFTER_CONQUEST,
	GAMEOPTION_NO_BARBARIANS,
	GAMEOPTION_RAGING_BARBARIANS,
	GAMEOPTION_AGGRESSIVE_AI,
	GAMEOPTION_RANDOM_PERSONALITIES,
	GAMEOPTION_NO_TECH_TRADING,
	GAMEOPTION_PERMANENT_ALLIANCES,
	GAMEOPTION_ALWAYS_WAR,
	GAMEOPTION_ALWAYS_PEACE,
	GAMEOPTION_ONE_CITY_CHALLENGE,
	GAMEOPTION_NO_CHANGING_WAR_PEACE,
	GAMEOPTION_NEW_RANDOM_SEED,
	GAMEOPTION_LOCK_MODS,
	GAMEOPTION_COMPLETE_KILLS,

	NUM_GAMEOPTION_TYPES
};

enum DllExport MultiplayerOptionTypes		// Exposed to Python
{
	NO_MPOPTION = -1,

	MPOPTION_SIMULTANEOUS_TURNS,
	MPOPTION_TAKEOVER_AI,
	MPOPTION_TURN_TIMER,

	NUM_MPOPTION_TYPES
};

enum DllExport SpecialOptionTypes			// Exposed to Python
{
	NO_SPECIALOPTION = -1,

	SPECIALOPTION_REPORT_STATS,

	NUM_SPECIALOPTION_TYPES,
};

enum DllExport PlayerOptionTypes			// Exposed to Python
{
	NO_PLAYEROPTION = -1,

	PLAYEROPTION_ADVISOR_POPUPS,
	PLAYEROPTION_ADVISOR_HELP,
	PLAYEROPTION_WAIT_END_TURN,
	PLAYEROPTION_MINIMIZE_POP_UPS,
	PLAYEROPTION_SHOW_FRIENDLY_MOVES,
	PLAYEROPTION_SHOW_ENEMY_MOVES,
	PLAYEROPTION_QUICK_MOVES,
	PLAYEROPTION_QUICK_ATTACK,
	PLAYEROPTION_QUICK_DEFENSE,
	PLAYEROPTION_STACK_ATTACK,
	PLAYEROPTION_AUTO_PROMOTION,
	PLAYEROPTION_START_AUTOMATED,
	PLAYEROPTION_SAFE_AUTOMATION,
	PLAYEROPTION_NUMPAD_HELP,
	PLAYEROPTION_NO_UNIT_CYCLING,
	PLAYEROPTION_NO_UNIT_RECOMMENDATIONS,
	PLAYEROPTION_RIGHT_CLICK_MENU,
	PLAYEROPTION_LEAVE_FORESTS,

	NUM_PLAYEROPTION_TYPES
};

enum DllExport GraphicOptionTypes			// Exposed to Python
{
	NO_GRAPHICOPTION = -1,

	GRAPHICOPTION_SINGLE_UNIT_GRAPHICS,
	GRAPHICOPTION_HEALTH_BARS,
	GRAPHICOPTION_CITY_DETAIL,
	GRAPHICOPTION_NO_COMBAT_ZOOM,
	GRAPHICOPTION_FROZEN_ANIMATIONS,
	GRAPHICOPTION_EFFECTS_DISABLED,
	GRAPHICOPTION_GLOBE_VIEW_BUILDINGS_DISABLED,
	GRAPHICOPTION_FULLSCREEN,
	GRAPHICOPTION_LOWRES_TEXTURES,
	GRAPHICOPTION_HIRES_TERRAIN,
	GRAPHICOPTION_NO_MOVIES,
	GRAPHICOPTION_CITY_RADIUS,

	NUM_GRAPHICOPTION_TYPES
};

enum DllExport ForceControlTypes			// Exposed to Python
{
	NO_FORCECONTROL = -1,

	FORCECONTROL_SPEED,
	FORCECONTROL_HANDICAP,
	FORCECONTROL_OPTIONS,
	FORCECONTROL_VICTORIES,
	FORCECONTROL_MAX_TURNS,
	FORCECONTROL_MAX_CITY_ELIMINATION,

	NUM_FORCECONTROL_TYPES
};

enum DllExport VictoryTypes					// Exposed to Python
{
	NO_VICTORY = -1,
};

enum DllExport FeatureTypes					// Exposed to Python
{
	NO_FEATURE = -1,
};

enum DllExport BonusTypes						// Exposed to Python
{
	NO_BONUS = -1,
};

enum DllExport BonusClassTypes			// Exposed to Python
{
	NO_BONUSCLASS = -1,
};

enum DllExport ImprovementTypes			// Exposed to Python
{
	NO_IMPROVEMENT = -1,
};

enum DllExport RouteTypes						// Exposed to Python
{
	NO_ROUTE = -1,
};

enum DllExport RiverTypes						// Exposed to Python
{
	NO_RIVER = -1,
};

enum DllExport GoodyTypes						// Exposed to Python
{
	NO_GOODY = -1,
};

enum DllExport BuildTypes						// Exposed to Python
{
	NO_BUILD = -1,
};

enum DllExport SymbolTypes					// Exposed to Python
{
	NO_SYMBOL = -1,
};

enum DllExport FontSymbols					// Exposed to Python
{
	// 'OTHER' symbols
	HAPPY_CHAR = 0,
	UNHAPPY_CHAR,
	HEALTHY_CHAR,
	UNHEALTHY_CHAR,
	BULLET_CHAR,
	STRENGTH_CHAR,
	MOVES_CHAR,
	RELIGION_CHAR,
	STAR_CHAR,
	SILVER_STAR_CHAR,
	TRADE_CHAR,
	DEFENSE_CHAR,
	GREAT_PEOPLE_CHAR,
	BAD_GOLD_CHAR,
	BAD_FOOD_CHAR,
	EATEN_FOOD_CHAR,
	GOLDEN_AGE_CHAR,
	ANGRY_POP_CHAR,
	OPEN_BORDERS_CHAR,
	DEFENSIVE_PACT_CHAR,
	MAP_CHAR,
	OCCUPATION_CHAR,
	POWER_CHAR,

	MAX_NUM_SYMBOLS
};

enum DllExport HandicapTypes				// Exposed to Python
{
	NO_HANDICAP = -1,
};

enum DllExport GameSpeedTypes				// Exposed to Python
{
	NO_GAMESPEED = -1,
};

enum DllExport TurnTimerTypes				// Exposed to Python
{
	NO_TURNTIMER = -1,
};

enum DllExport EraTypes							// Exposed to Python
{
	NO_ERA = -1,
};

enum DllExport CivilizationTypes		// Exposed to Python
{
	NO_CIVILIZATION = -1,
};

enum DllExport LeaderHeadTypes			// Exposed to Python
{
	NO_LEADER = -1,
};

// Used for managing Art Differences based on nationality
enum DllExport ArtStyleTypes				// Exposed to Python
{
	NO_ARTSTYLE = -1,
};

enum DllExport CitySizeTypes				// Exposed to Python
{
	NO_CITYSIZE = -1,

	CITYSIZE_SMALL,
	CITYSIZE_MEDIUM,
	CITYSIZE_LARGE,

	NUM_CITYSIZE_TYPES
};

enum DllExport FootstepAudioTypes		// Exposed to Python
{
	NO_FOOTSTEPAUDIO = -1,
};

enum DllExport FootstepAudioTags		// Exposed to Python
{
	NO_FOOTSTEPAUDIO_TAG = -1,
};

enum DllExport ChatTargetTypes			// Exposed to Python
{
	NO_CHATTARGET = -1,
	CHATTARGET_ALL = -2,
	CHATTARGET_TEAM = -3,
};

enum DllExport VoiceTargetTypes			// Exposed to Python
{
	NO_VOICETARGET = -1,

	VOICETARGET_DIPLO,
	VOICETARGET_TEAM,
	VOICETARGET_ALL,

	NUM_VOICETARGETS
};

enum DllExport TeamTypes					// Exposed to Python
{
	NO_TEAM = -1,
};

enum DllExport PlayerTypes				// Exposed to Python
{
	NO_PLAYER = -1,
};

enum DllExport TraitTypes					// Exposed to Python
{
	NO_TRAIT = -1,
};

enum DllExport OrderTypes					// Exposed to Python
{
	NO_ORDER = -1,

	ORDER_TRAIN,
	ORDER_CONSTRUCT,
	ORDER_CREATE,
	ORDER_MAINTAIN,

	NUM_ORDER_TYPES
};

enum DllExport TaskTypes				// Exposed to Python
{
	TASK_RAZE,
	TASK_DISBAND,
	TASK_GIFT,
	TASK_SET_AUTOMATED_CITIZENS,
	TASK_SET_AUTOMATED_PRODUCTION,
  TASK_SET_EMPHASIZE,
	TASK_CHANGE_SPECIALIST,
	TASK_CHANGE_WORKING_PLOT,
	TASK_CLEAR_WORKING_OVERRIDE,
	TASK_HURRY,
	TASK_CONSCRIPT,
	TASK_CLEAR_ORDERS,
	TASK_RALLY_PLOT,
	TASK_CLEAR_RALLY_PLOT,

	NUM_TASK_TYPES
};

enum DllExport BuildingClassTypes				// Exposed to Python 
{
	NO_BUILDINGCLASS = -1,
};

enum DllExport BuildingTypes						// Exposed to Python
{
	NO_BUILDING = -1,
};

enum DllExport SpecialBuildingTypes			// Exposed to Python
{
	NO_SPECIALBUILDING = -1,
};

enum DllExport ProjectTypes				// Exposed to Python
{
	NO_PROJECT = -1,
};

enum DllExport ProcessTypes				// Exposed to Python
{
	NO_PROCESS = -1,
};

enum DllExport VoteTypes					// Exposed to Python
{
	NO_VOTE = -1,
};

enum DllExport InfoBarTypes				// Exposed to Python
{
	INFOBAR_STORED,
	INFOBAR_RATE,
	INFOBAR_RATE_EXTRA,
	INFOBAR_EMPTY,

	NUM_INFOBAR_TYPES
};

enum DllExport HealthBarTypes			// Exposed to Python
{
	HEALTHBAR_ALIVE_ATTACK,
	HEALTHBAR_ALIVE_DEFEND,
	HEALTHBAR_DEAD,

	NUM_HEALTHBAR_TYPES
};

enum DllExport ConceptTypes				// Exposed to Python
{
	NO_CONCEPT = -1,
};

enum DllExport CalendarTypes			// Exposed to Python
{
	NO_CALENDAR = -1, 

	CALENDAR_DEFAULT,
	CALENDAR_YEARS,
	CALENDAR_TURNS,
	CALENDAR_SEASONS,
	CALENDAR_MONTHS,
	CALENDAR_WEEKS,
};

enum DllExport SeasonTypes				// Exposed to Python
{
	NO_SEASON = -1,
};

enum DllExport MonthTypes					// Exposed to Python
{
	NO_MONTH = -1,
};

enum DllExport DenialTypes				// Exposed to Python
{
	NO_DENIAL = -1,

	DENIAL_UNKNOWN,
	DENIAL_NEVER,
	DENIAL_TOO_MUCH,
	DENIAL_MYSTERY,
	DENIAL_JOKING,
	DENIAL_ANGER_CIVIC,
	DENIAL_FAVORITE_CIVIC,
	DENIAL_MINORITY_RELIGION,
	DENIAL_CONTACT_THEM,
	DENIAL_VICTORY,
	DENIAL_ATTITUDE,
	DENIAL_ATTITUDE_THEM,
	DENIAL_TECH_WHORE,
	DENIAL_TECH_MONOPOLY,
	DENIAL_POWER_US,
	DENIAL_POWER_YOU,
	DENIAL_POWER_THEM,
	DENIAL_TOO_MANY_WARS,
	DENIAL_NO_GAIN,
	DENIAL_NOT_ALLIED,
	DENIAL_RECENT_CANCEL,
	DENIAL_WORST_ENEMY,

	NUM_DENIAL_TYPES
};

enum DllExport DomainTypes			// Exposed to Python
{
	NO_DOMAIN = -1,

	DOMAIN_SEA,
	DOMAIN_AIR,
	DOMAIN_LAND,
	DOMAIN_IMMOBILE,

	NUM_DOMAIN_TYPES
};

enum DllExport UnitClassTypes		// Exposed to Python
{
	NO_UNITCLASS = -1,
};

enum DllExport UnitTypes				// Exposed to Python
{
	NO_UNIT = -1,
};

enum DllExport SpecialUnitTypes	// Exposed to Python
{
	NO_SPECIALUNIT = -1,
};

enum DllExport UnitCombatTypes	// Exposed to Python
{
	NO_UNITCOMBAT = -1,
};

enum DllExport UnitAITypes			// Exposed to Python
{
	NO_UNITAI = -1,

	UNITAI_UNKNOWN,
	UNITAI_ANIMAL,
	UNITAI_SETTLE,
	UNITAI_WORKER,
	UNITAI_ATTACK,
	UNITAI_ATTACK_CITY,
	UNITAI_COLLATERAL,
	UNITAI_PILLAGE,
	UNITAI_RESERVE,
	UNITAI_COUNTER,
	UNITAI_CITY_DEFENSE,
	UNITAI_CITY_COUNTER,
	UNITAI_CITY_SPECIAL,
	UNITAI_EXPLORE,
	UNITAI_MISSIONARY,
	UNITAI_PROPHET,
	UNITAI_ARTIST,
	UNITAI_SCIENTIST,
	UNITAI_MERCHANT,
	UNITAI_ENGINEER,
	UNITAI_SPY,
	UNITAI_ICBM,
	UNITAI_WORKER_SEA,
	UNITAI_ATTACK_SEA,
	UNITAI_RESERVE_SEA,
	UNITAI_ESCORT_SEA,
	UNITAI_EXPLORE_SEA,
	UNITAI_ASSAULT_SEA,
	UNITAI_SETTLER_SEA,
	UNITAI_MISSIONARY_SEA,
	UNITAI_SPY_SEA,
	UNITAI_CARRIER_SEA,
	UNITAI_ATTACK_AIR,
	UNITAI_DEFENSE_AIR,
	UNITAI_CARRIER_AIR,

	NUM_UNITAI_TYPES
};

enum DllExport InvisibleTypes			// Exposed to Python
{
	NO_INVISIBLE = -1,
};

enum DllExport ProbabilityTypes		// Exposed to Python
{
	NO_PROBABILITY = -1,

	PROBABILITY_LOW,
	PROBABILITY_REAL,
	PROBABILITY_HIGH,

	NUM_PROBABILITY_TYPES
};

enum DllExport ActivityTypes			// Exposed to Python
{
	NO_ACTIVITY = -1,

	ACTIVITY_AWAKE,
	ACTIVITY_HOLD,
	ACTIVITY_SLEEP,
	ACTIVITY_HEAL,
	ACTIVITY_SENTRY,
	ACTIVITY_INTERCEPT,
	ACTIVITY_MISSION,

	NUM_ACTIVITY_TYPES
};

enum DllExport AutomateTypes			// Exposed to Python
{
	NO_AUTOMATE = -1,

	AUTOMATE_BUILD,
	AUTOMATE_NETWORK,
	AUTOMATE_CITY,
	AUTOMATE_EXPLORE,

	NUM_AUTOMATE_TYPES
};

// any additions need to be reflected in GlobalTypes.xml
enum DllExport MissionTypes				// Exposed to Python
{
	NO_MISSION = -1,

	MISSION_MOVE_TO,
	MISSION_ROUTE_TO,
	MISSION_MOVE_TO_UNIT,
	MISSION_SKIP,
	MISSION_SLEEP,
	MISSION_FORTIFY,
	MISSION_AIRPATROL,
	MISSION_HEAL,
	MISSION_SENTRY,
	MISSION_AIRLIFT,
	MISSION_NUKE,
	MISSION_RECON,
	MISSION_AIRBOMB,
	MISSION_BOMBARD,
	MISSION_PILLAGE,
	MISSION_SABOTAGE,
	MISSION_DESTROY,
	MISSION_STEAL_PLANS,
	MISSION_FOUND,
	MISSION_SPREAD,
	MISSION_JOIN,
	MISSION_CONSTRUCT,
	MISSION_DISCOVER,
	MISSION_HURRY,
	MISSION_TRADE,
	MISSION_GREAT_WORK,
	MISSION_GOLDEN_AGE,
	MISSION_BUILD,

	MISSION_BEGIN_COMBAT,
	MISSION_END_COMBAT,
	MISSION_AIRSTRIKE,
	MISSION_SURRENDER,
	MISSION_CAPTURED,
	MISSION_IDLE,
	MISSION_DIE,
	MISSION_DAMAGE,
	MISSION_MULTI_SELECT,
	MISSION_MULTI_DESELECT,

	NUM_MISSION_TYPES
};

enum DllExport MissionAITypes		// Exposed to Python
{
	NO_MISSIONAI = -1,

	MISSIONAI_SHADOW,
	MISSIONAI_GROUP,
	MISSIONAI_LOAD_ASSAULT,
	MISSIONAI_LOAD_SETTLER,
	MISSIONAI_LOAD_SPECIAL,
	MISSIONAI_GUARD_CITY,
	MISSIONAI_GUARD_BONUS,
	MISSIONAI_GUARD_SPY,
	MISSIONAI_ATTACK_SPY,
	MISSIONAI_SPREAD,
	MISSIONAI_CONSTRUCT,
	MISSIONAI_HURRY,
	MISSIONAI_GREAT_WORK,
	MISSIONAI_EXPLORE,
	MISSIONAI_BLOCKADE,
	MISSIONAI_PILLAGE,
	MISSIONAI_FOUND,
	MISSIONAI_BUILD,
	MISSIONAI_ASSAULT,
	MISSIONAI_CARRIER,
	MISSIONAI_PICKUP,

	NUM_MISSIONAI_TYPES
};

// any additions need to be reflected in GlobalTypes.xml
enum DllExport CommandTypes					// Exposed to Python
{
	NO_COMMAND = -1,

	COMMAND_PROMOTION,
	COMMAND_UPGRADE,
	COMMAND_AUTOMATE,
	COMMAND_WAKE,
	COMMAND_CANCEL,
	COMMAND_CANCEL_ALL,
	COMMAND_STOP_AUTOMATION,
	COMMAND_DELETE,
	COMMAND_GIFT,
	COMMAND_LOAD,
	COMMAND_LOAD_UNIT,
	COMMAND_UNLOAD,
	COMMAND_UNLOAD_ALL,
	COMMAND_HOTKEY,

	NUM_COMMAND_TYPES
};

enum DllExport ControlTypes					// Exposed to Python
{
	NO_CONTROL = -1,

	CONTROL_CENTERONSELECTION,
	CONTROL_SELECTYUNITTYPE,
	CONTROL_SELECTYUNITALL,
	CONTROL_SELECTCITY,
	CONTROL_SELECTCAPITAL,
	CONTROL_NEXTCITY,
	CONTROL_PREVCITY,
	CONTROL_NEXTUNIT,
	CONTROL_PREVUNIT,
	CONTROL_CYCLEUNIT,
	CONTROL_CYCLEUNIT_ALT,
	CONTROL_CYCLEWORKER,
	CONTROL_LASTUNIT,
	CONTROL_ENDTURN,
	CONTROL_ENDTURN_ALT,
	CONTROL_FORCEENDTURN,
	CONTROL_AUTOMOVES,
	CONTROL_PING,
	CONTROL_SIGN,
	CONTROL_GRID,
	CONTROL_BARE_MAP,
	CONTROL_YIELDS,
	CONTROL_RESOURCE_ALL,
	CONTROL_GLOBELAYER,
	CONTROL_SCORES,
	CONTROL_LOAD_GAME,
	CONTROL_OPTIONS_SCREEN,
	CONTROL_RETIRE,
	CONTROL_SAVE_GROUP,
	CONTROL_SAVE_NORMAL,
	CONTROL_QUICK_SAVE,
	CONTROL_QUICK_LOAD,
	CONTROL_ORTHO_CAMERA,
	CONTROL_CYCLE_CAMERA_FLYING_MODES,
	CONTROL_ISOMETRIC_CAMERA_LEFT,
	CONTROL_ISOMETRIC_CAMERA_RIGHT,
	CONTROL_FLYING_CAMERA,
	CONTROL_MOUSE_FLYING_CAMERA,
	CONTROL_TOP_DOWN_CAMERA,
	CONTROL_CIVILOPEDIA,
	CONTROL_RELIGION_SCREEN,
	CONTROL_CIVICS_SCREEN,
	CONTROL_FOREIGN_SCREEN,
	CONTROL_FINANCIAL_SCREEN,
	CONTROL_MILITARY_SCREEN,
	CONTROL_TECH_CHOOSER,
	CONTROL_TURN_LOG,
	CONTROL_CHAT_ALL,
	CONTROL_CHAT_TEAM,
	CONTROL_DOMESTIC_SCREEN,
	CONTROL_VICTORY_SCREEN,
	CONTROL_INFO,
	CONTROL_GLOBE_VIEW,
	CONTROL_DETAILS,
	CONTROL_ADMIN_DETAILS,
	CONTROL_HALL_OF_FAME,
	CONTROL_WORLD_BUILDER,
	CONTROL_DIPLOMACY,

	NUM_CONTROL_TYPES
};

enum DllExport PromotionTypes				// Exposed to Python
{
	NO_PROMOTION = -1,
};

enum DllExport TechTypes						// Exposed to Python
{
	NO_TECH = -1,
};

enum DllExport SpecialistTypes			// Exposed to Python
{
	NO_SPECIALIST = -1,
};

enum DllExport ReligionTypes				// Exposed to Python
{
	NO_RELIGION = -1,
};

enum DllExport HurryTypes						// Exposed to Python
{
	NO_HURRY = -1,
};

enum DllExport UpkeepTypes					// Exposed to Python
{
	NO_UPKEEP = -1,
};

enum DllExport CultureLevelTypes		// Exposed to Python
{
	NO_CULTURELEVEL = -1,
};

enum DllExport CivicOptionTypes			// Exposed to Python
{
	NO_CIVICOPTION = -1,
};

enum DllExport CivicTypes						// Exposed to Python
{
	NO_CIVIC = -1,
};

enum DllExport WarPlanTypes					// Exposed to Python
{
	NO_WARPLAN = -1,

	WARPLAN_ATTACKED_RECENT,
	WARPLAN_ATTACKED,
	WARPLAN_PREPARING_LIMITED,
	WARPLAN_PREPARING_TOTAL,
	WARPLAN_LIMITED,
	WARPLAN_TOTAL,
	WARPLAN_DOGPILE,

	NUM_WARPLAN_TYPES
};

enum DllExport AreaAITypes					// Exposed to Python
{
	NO_AREAAI = -1,

	AREAAI_OFFENSIVE,
	AREAAI_DEFENSIVE,
	AREAAI_MASSING,
	AREAAI_ASSAULT,
	AREAAI_NEUTRAL,

	NUM_AREAAI_TYPES
};

enum DllExport EndTurnButtonStates	// Exposed to Python
{
	END_TURN_GO,
	END_TURN_OVER_HIGHLIGHT,
	END_TURN_OVER_DARK,

	NUM_END_TURN_STATES,
};

enum DllExport FogOfWarModeTypes		// Exposed to Python
{
	FOGOFWARMODE_OFF,
	FOGOFWARMODE_EXPLORED,
	FOGOFWARMODE_UNEXPLORED,
	FOGOFWARMODE_NOVIS,

	NUM_FOGOFWARMODE_TYPES
};

// AnimationTypes is depreciated, and will be eventually removed.
// BONUSANIMATION_* and IMPROVEMENTANIMATION_* are still used, and will be left.

enum DllExport AnimationTypes			// Exposed to Python
{
	NONE_ANIMATION = -1,	// NO_ANIMATION is used by FirePlace

	BONUSANIMATION_UNIMPROVED = 1,
	BONUSANIMATION_NOT_WORKED,
	BONUSANIMATION_WORKED,

	IMPROVEMENTANIMATION_OFF = 2,
	IMPROVEMENTANIMATION_ON,
	IMPROVEMENTANIMATION_OFF_EXTRA,
	IMPROVEMENTANIMATION_ON_EXTRA_1,
	IMPROVEMENTANIMATION_ON_EXTRA_2,
	IMPROVEMENTANIMATION_ON_EXTRA_3,
	IMPROVEMENTANIMATION_ON_EXTRA_4,
};

enum DllExport EntityEventTypes		// Exposed to Python
{
	ENTEVENT_NONE = -1,			//!< Invalid event
};

enum DllExport AnimationPathTypes	// Exposed to Python
{
	ANIMATIONPATH_NONE = -1,

	// Default animation paths
	ANIMATIONPATH_IDLE,
	ANIMATIONPATH_MOVE,
	ANIMATIONPATH_DIE,					//!< The unit is dying (used for collateral damage - NOT combat)
	ANIMATIONPATH_DAMAGE,				//!< Updates the damage state for the unit

	// Combat related animation paths
	ANIMATIONPATH_MELEE_BEGIN,
	ANIMATIONPATH_MELEE_STRIKE,
	ANIMATIONPATH_MELEE_HURT,
	ANIMATIONPATH_MELEE_DIE,
	ANIMATIONPATH_MELEE_FORTIFIED,
	ANIMATIONPATH_MELEE_DIE_FADE,		//!< Used only in combat. The colateral damage die should have a fade integrated.
	ANIMATIONPATH_MELEE_FLEE,			//!< Used only by settler children, so they don't die in combat
	ANIMATIONPATH_MELEE_END,

	// Ranged combat related animation paths
	ANIMATIONPATH_RANGED_BEGIN,
	ANIMATIONPATH_RANGED_STRIKE,
	ANIMATIONPATH_RANGED_HURT,
	ANIMATIONPATH_RANGED_DIE,
	ANIMATIONPATH_RANGED_FORTIFIED,
	ANIMATIONPATH_RANGED_RUNHIT,
	ANIMATIONPATH_RANGED_RUNDIE,
	ANIMATIONPATH_RANGED_DIE_FADE,		//!< Used only in combat. The colateral damage die should have a fade integrated.
	ANIMATIONPATH_RANGED_END,

	// Air Units animation paths
	ANIMATIONPATH_AIRFADEIN,
	ANIMATIONPATH_AIRFADEOUT,
	ANIMATIONPATH_AIRSTRIKE,
	ANIMATIONPATH_AIRBOMB,
};

//!<  Enumeration for the animation category types.
enum AnimationCategoryTypes			// Exposed to Python
{
	ANIMCAT_NONE = -1,
};

//!< Animation category operators.
enum AnimationOperatorTypes
{
	ANIMOP_FIRST = 1001,
	ANIMOP_RAND_FPR = ANIMOP_FIRST,			//!< Sets the FPR to a random number [0..1].
	ANIMOP_SET_FPR,							//!< Sets the FPR to the input value
	ANIMOP_SET_BR,							//!< Sets the BR to true the input value is non-zero
	ANIMOP_ADD_FPR,							//!< Adds the input value to the FPR register (input can be negative)
	ANIMOP_TEST_GT,							//!< Sets/resets the BR if the FPR is greater than the input
	ANIMOP_TEST_LT,							//!< Sets/resets the BR if the FPR is less than the input
	ANIMOP_LOAD_CAS,						//!< Sets the FPR to the CAS/32.
	ANIMOP_SETCAS_IF,						//!< Modifies the current animation set, by setting it to ((FPR*32)%32)
	ANIMOP_SKIP_IF,							//!< Skips the given number of instructions if the BR is true
	ANIMOP_CAS_INCR,						//!< Increments the CAS (and resets to zero if it is the maximum)
	ANIMOP_IS_RANGED,						//!< Sets the BR to true if the unit is "ranged", and to false otherwise
	ANIMOP_SET_LAYERED,						//!< Sets indicates that the paths that follow should be played as layered animations
	ANIMOP_DEACT_LAYERED,					//!< Deactivates all animations that are layered
	ANIMOP_SETCAS_DAMAGE,					//!< Set the current animation set to the damage level of the unit (damage/art define max)
	ANIMOP_LAST
};

enum DllExport CursorTypes							// Exposed to Python
{
	NO_CURSOR = -1,
};

enum DllExport FunctionTypes
{
	FUNC_NOINTERP = 0,	// NiAnimationKey::NOINTERP,
	FUNC_LINKEY,	//	= NiAnimationKey::LINKEY,
	FUNC_BEZKEY,	//	= NiAnimationKey::BEZKEY,
	FUNC_TCBKEY,	// = NiAnimationKey::TCBKEY,
	FUNC_EULERKEY,	// = NiAnimationKey::EULERKEY,
	FUNC_STEPKEY,	// = NiAnimationKey::STEPKEY,

	NUM_FUNC_TYPES	// = NiAnimationKey::NUMKEYTYPES
};

enum DllExport TradeableItems						// Exposed to Python
{
	TRADE_ITEM_NONE = -1,

	TRADE_GOLD,
	TRADE_GOLD_PER_TURN,
	TRADE_MAPS,
	TRADE_OPEN_BORDERS,
	TRADE_DEFENSIVE_PACT,
	TRADE_PERMANENT_ALLIANCE,
	TRADE_PEACE_TREATY,

	NUM_BASIC_ITEMS,

	TRADE_TECHNOLOGIES = NUM_BASIC_ITEMS,
	TRADE_RESOURCES,
	TRADE_CITIES,
	TRADE_PEACE,
	TRADE_WAR,
	TRADE_EMBARGO,
	TRADE_CIVIC,
	TRADE_RELIGION,

	NUM_TRADEABLE_HEADINGS,

	NUM_TRADEABLE_ITEMS = NUM_TRADEABLE_HEADINGS,
};

enum DllExport DiploEventTypes					// Exposed to Python
{
	NO_DIPLOEVENT = -1,

	DIPLOEVENT_CONTACT,
	DIPLOEVENT_AI_CONTACT,
	DIPLOEVENT_FAILED_CONTACT,
	DIPLOEVENT_GIVE_HELP,
	DIPLOEVENT_REFUSED_HELP,
	DIPLOEVENT_ACCEPT_DEMAND,
	DIPLOEVENT_REJECTED_DEMAND,
	DIPLOEVENT_DEMAND_WAR,
	DIPLOEVENT_CONVERT,
	DIPLOEVENT_NO_CONVERT,
	DIPLOEVENT_REVOLUTION,
	DIPLOEVENT_NO_REVOLUTION,
	DIPLOEVENT_JOIN_WAR,
	DIPLOEVENT_NO_JOIN_WAR,
	DIPLOEVENT_STOP_TRADING,
	DIPLOEVENT_NO_STOP_TRADING,
	DIPLOEVENT_ASK_HELP,
	DIPLOEVENT_MADE_DEMAND,
	DIPLOEVENT_RESEARCH_TECH,
	DIPLOEVENT_TARGET_CITY,

	NUM_DIPLOEVENT_TYPES
};

enum DllExport DiploCommentTypes				// Exposed to Python 
{
	NO_DIPLOCOMMENT = -1
};

enum DllExport NetContactTypes					// Exposed to Python 
{
	NETCONTACT_INITIAL,
	NETCONTACT_RESPONSE,

	NUM_NETCONTACT_TYPES,
};

enum DllExport ContactTypes							// Exposed to Python 
{
	CONTACT_RELIGION_PRESSURE,
	CONTACT_CIVIC_PRESSURE,
	CONTACT_JOIN_WAR,
	CONTACT_STOP_TRADING,
	CONTACT_GIVE_HELP,
	CONTACT_ASK_FOR_HELP,
	CONTACT_DEMAND_TRIBUTE,
	CONTACT_OPEN_BORDERS,
	CONTACT_DEFENSIVE_PACT,
	CONTACT_PERMANENT_ALLIANCE,
	CONTACT_PEACE_TREATY,
	CONTACT_TRADE_TECH,
	CONTACT_TRADE_BONUS,
	CONTACT_TRADE_MAP,

	NUM_CONTACT_TYPES
};

enum DllExport MemoryTypes							// Exposed to Python 
{
	MEMORY_DECLARED_WAR,
	MEMORY_DECLARED_WAR_ON_FRIEND,
	MEMORY_HIRED_WAR_ALLY,
	MEMORY_NUKED_US,
	MEMORY_NUKED_FRIEND,
	MEMORY_RAZED_CITY,
	MEMORY_RAZED_HOLY_CITY,
	MEMORY_SPY_CAUGHT,
	MEMORY_GIVE_HELP,
	MEMORY_REFUSED_HELP,
	MEMORY_ACCEPT_DEMAND,
	MEMORY_REJECTED_DEMAND,
	MEMORY_ACCEPTED_RELIGION,
	MEMORY_DENIED_RELIGION,
	MEMORY_ACCEPTED_CIVIC,
	MEMORY_DENIED_CIVIC,
	MEMORY_ACCEPTED_JOIN_WAR,
	MEMORY_DENIED_JOIN_WAR,
	MEMORY_ACCEPTED_STOP_TRADING,
	MEMORY_DENIED_STOP_TRADING,
	MEMORY_STOPPED_TRADING,
	MEMORY_STOPPED_TRADING_RECENT,
	MEMORY_HIRED_TRADE_EMBARGO,
	MEMORY_MADE_DEMAND,
	MEMORY_MADE_DEMAND_RECENT,
	MEMORY_CANCELLED_OPEN_BORDERS,
	MEMORY_TRADED_TECH_TO_US,
	MEMORY_RECEIVED_TECH_FROM_ANY,

	NUM_MEMORY_TYPES
};

enum DllExport AttitudeTypes				// Exposed to Python 
{
	NO_ATTITUDE = -1,

	ATTITUDE_FURIOUS,
	ATTITUDE_ANNOYED,
	ATTITUDE_CAUTIOUS,
	ATTITUDE_PLEASED,
	ATTITUDE_FRIENDLY,

	NUM_ATTITUDE_TYPES
};

//! Enumeration for playing events with CvLeaderheadWidget
enum DllExport LeaderheadAction			// Exposed to Python
{
	NO_LEADERANIM = -1,		//!< If used with CvLeaderheadWidget::PerformAction, plays the idle animation

	LEADERANIM_GREETING,		//!< The leaderhead greets you
	LEADERANIM_FRIENDLY,		//!< The leaderhead is friendly to you
	LEADERANIM_PLEASED,			//!< The leaderhead is pleased
	LEADERANIM_CAUTIOUS,		//!< The leaderhead is cautious
	LEADERANIM_ANNOYED,			//!< The leaderhead is annoyed
	LEADERANIM_FURIOUS,			//!< The leaderhead is furious
	LEADERANIM_DISAGREE,		//!< The leaderhead makes a disagree gesture
	LEADERANIM_AGREE,				//!< The leaderhead makes an agree gesture

	NUM_LEADERANIM_TYPES			//!< The number of leaderhead event types
};

enum DllExport DiplomacyPowerTypes	// Exposed to Python
{
	NO_DIPLOMACYPOWER		= -1,
	DIPLOMACYPOWER_WEAKER,
	DIPLOMACYPOWER_EQUAL,
	DIPLOMACYPOWER_STRONGER,

	NUM_DIPLOMACYPOWER_TYPES
};

enum DllExport FeatTypes						// Exposed to Python
{
	FEAT_UNITCOMBAT_ARCHER,
	FEAT_UNITCOMBAT_MOUNTED,
	FEAT_UNITCOMBAT_MELEE,
	FEAT_UNITCOMBAT_SIEGE,
	FEAT_UNITCOMBAT_GUN,
	FEAT_UNITCOMBAT_ARMOR,
	FEAT_UNITCOMBAT_HELICOPTER,
	FEAT_UNITCOMBAT_NAVAL,
	FEAT_NATIONAL_WONDER,
	FEAT_TRADE_ROUTE,
	FEAT_COPPER_CONNECTED,
	FEAT_HORSE_CONNECTED,
	FEAT_IRON_CONNECTED,
	FEAT_LUXURY_CONNECTED,
	FEAT_FOOD_CONNECTED,
	FEAT_POPULATION_HALF_MILLION,
	FEAT_POPULATION_1_MILLION,
	FEAT_POPULATION_2_MILLION,
	FEAT_POPULATION_5_MILLION,
	FEAT_POPULATION_10_MILLION,
	FEAT_POPULATION_20_MILLION,
	FEAT_POPULATION_50_MILLION,
	FEAT_POPULATION_100_MILLION,
	FEAT_POPULATION_200_MILLION,
	FEAT_POPULATION_500_MILLION,
	FEAT_POPULATION_1_BILLION,
	FEAT_POPULATION_2_BILLION,
	FEAT_PAD,

	NUM_FEAT_TYPES
};

enum DllExport SaveGameTypes			// Exposed to Python
{
	SAVEGAME_NONE = -1,
	
	SAVEGAME_AUTO,
	SAVEGAME_RECOVERY,
	SAVEGAME_QUICK,
	SAVEGAME_NORMAL,
	SAVEGAME_GROUP,
	SAVEGAME_DROP_QUIT,
	SAVEGAME_DROP_CONTINUE,
	SAVEGAME_PBEM,
	SAVEGAME_REPLAY,

	NUM_SAVEGAME_TYPES
};

enum DllExport InitializationStates
{
	INIT_OK,
	INIT_FAILED,

	NUM_INIT_STATES,
};

enum DllExport GameType				// Exposed to Python
{
	GAME_NONE = -1,

	GAME_SP_NEW,
	GAME_SP_SCENARIO,
	GAME_SP_LOAD,
	GAME_MP_NEW,
	GAME_MP_SCENARIO,
	GAME_MP_LOAD,
	GAME_HOTSEAT_NEW,
	GAME_HOTSEAT_SCENARIO,
	GAME_HOTSEAT_LOAD,
	GAME_PBEM_NEW,
	GAME_PBEM_SCENARIO,
	GAME_PBEM_LOAD,
	GAME_REPLAY,

	NUM_GAMETYPES,
};

enum DllExport GameMode				// Exposed to Python
{
	NO_GAMEMODE = -1,

	GAMEMODE_NORMAL,
	GAMEMODE_PITBOSS,

	NUM_GAMEMODES
};

enum DllExport GamePwdTypes
{
	NO_PWDTYPE = -1,

	PWD_NEWGAME,
	PWD_SCENARIO,
	PWD_JOINGAME,

	NUM_PWDTYPES,
};

enum DllExport SlotClaim
{
	SLOTCLAIM_UNASSIGNED,
	SLOTCLAIM_RESERVED,
	SLOTCLAIM_ASSIGNED,

	NUM_SLOTCLAIMS,
};

enum DllExport SlotStatus
{
	SS_OPEN,
	SS_COMPUTER,
	SS_CLOSED,
	SS_TAKEN,

	SS_MAX_SLOT_STATUS,
};

enum DllExport InterfaceVisibility				// Exposed to Python
{
	INTERFACE_SHOW,
	INTERFACE_HIDE,
	INTERFACE_HIDE_ALL,
	INTERFACE_MINIMAP_ONLY,
};

enum DllExport GenericButtonSizes					// Exposed to Python
{
	BUTTON_SIZE_46,
	BUTTON_SIZE_32,
	BUTTON_SIZE_24,
	BUTTON_SIZE_16,

	BUTTON_SIZE_CUSTOM,
};

enum DllExport MenuScreenType
{
	MENU_SCREEN_STANDARD,
	MENU_SCREEN_BASELOBBY,
	MENU_SCREEN_BASE_SCENARIO,
	MENU_SCREEN_JOIN,
	MENU_SCREEN_BASE_LOAD,
	MENU_SCREEN_LAUNCHING,
	MENU_SCREEN_BASE_INIT,

	MENU_SCREEN_OPENING_MENU,
	MENU_SCREEN_MOD_MENU,

	MENU_SCREEN_GS_BUDDYLIST, 
	MENU_SCREEN_GS_CHATROOM,
	MENU_SCREEN_GS_CHANNEL,
	MENU_SCREEN_GS_CHOOSE_SCENARIO,
	MENU_SCREEN_GS_SCENARIO,
	MENU_SCREEN_GS_NAVBAR,
	MENU_SCREEN_GS_LOAD_STAGING,
	MENU_SCREEN_GS_MOTD,
	MENU_SCREEN_GS_LOGIN,
	MENU_SCREEN_GS_LOAD,
	MENU_SCREEN_GS_JOIN,
	MENU_SCREEN_GS_INIT,
	MENU_SCREEN_GS_CUSTOM_GAMES,

	MENU_SCREEN_LANLOBBY,
	MENU_SCREEN_MP_CHOOSE_SCENARIO,
	MENU_SCREEN_MP_SCENARIO,
	MENU_SCREEN_MP_LOAD_STAGING,
	MENU_SCREEN_MP_LOAD,
	MENU_SCREEN_MP_INIT,
	MENU_SCREEN_MP_CHOICES,
	MENU_SCREEN_MP_JOIN,

	MENU_SCREEN_SP_WORLD_SIZE,
	MENU_SCREEN_SP_SCENARIO,
	MENU_SCREEN_SP_LOAD,
	MENU_SCREEN_SP_INIT,
	MENU_SCREEN_SP_CHOICES,
	MENU_SCREEN_SP_ADVANCED_LOAD,
	MENU_SCREEN_SP_SIMPLE_CIV_PICKER,
	MENU_SCREEN_SP_REPLAY,
	MENU_SCREEN_SP_MAP_SCRIPT,
	MENU_SCREEN_SP_DIFFICULTY,
};

enum DllExport WorldBuilderPopupTypes			// Exposed to Python
{
	WBPOPUP_NONE = -1,

	WBPOPUP_START = 200,
	WBPOPUP_CITY=WBPOPUP_START,		// first entry, starts at 0
	WBPOPUP_UNIT,
	WBPOPUP_PLAYER,
	WBPOPUP_PLOT,
	WBPOPUP_TERRAIN,
	WBPOPUP_FEATURE,
	WBPOPUP_IMPROVEMENT,
	WBPOPUP_GAME,

	NUM_WBPOPUP,
};

enum DllExport EventType									// Exposed to Python
{
	// mouseEvent
	EVT_LBUTTONDOWN = 1,
	EVT_LBUTTONDBLCLICK,
	EVT_RBUTTONDOWN,
	EVT_BACK,
	EVT_FORWARD,

	// kbdEvent
	EVT_KEYDOWN,
	EVT_KEYUP,
};

// Different types of load
enum DllExport LoadType										// Exposed to Python
{
	LOAD_NORMAL,
	LOAD_INIT,
	LOAD_SETUP,
	LOAD_GAMETYPE,
	LOAD_REPLAY,
	LOAD_NORMAL_AND_GAMETYPE,
};

//	Available Fonts
enum DllExport FontTypes									// Exposed to Python
{
	TITLE_FONT,
	GAME_FONT,
	SMALL_FONT,
	MENU_FONT,
	MENU_HIGHLIGHT_FONT,
};

enum DllExport PanelStyles								// Exposed to Python
{
	// Built in styles
	PANEL_STYLE_STANDARD,
	PANEL_STYLE_SOLID,
	PANEL_STYLE_EMPTY,
	PANEL_STYLE_FLAT,
	PANEL_STYLE_IN,
	PANEL_STYLE_OUT,
	PANEL_STYLE_EXTERNAL,
	PANEL_STYLE_DEFAULT,

	// Civ specific styles
	PANEL_STYLE_CIVILPEDIA,
	PANEL_STYLE_STONE,
	PANEL_STYLE_UNITSTAT,
	PANEL_STYLE_BLUELARGE,
	PANEL_STYLE_BLUE50,

	PANEL_STYLE_TOPBAR,
	PANEL_STYLE_BOTTOMBAR,
	PANEL_STYLE_TECH,

	PANEL_STYLE_GAMEHUD_LEFT,
	PANEL_STYLE_GAMEHUD_RIGHT,
	PANEL_STYLE_GAMEHUD_CENTER,
	PANEL_STYLE_GAMEHUD_STATS,
	PANEL_STYLE_GAME_MAP,
	PANEL_STYLE_GAME_TOPBAR,
	PANEL_STYLE_HUD_HELP,

	PANEL_STYLE_CITY_LEFT,
	PANEL_STYLE_CITY_RIGHT,
	PANEL_STYLE_CITY_TOP,
	PANEL_STYLE_CITY_TANSHADE,
	PANEL_STYLE_CITY_INFO,
	PANEL_STYLE_CITY_TANTL,
	PANEL_STYLE_CITY_TANTR,
	PANEL_STYLE_CITY_COLUMNL,
	PANEL_STYLE_CITY_COLUMNC,
	PANEL_STYLE_CITY_COLUMNR,
	PANEL_STYLE_CITY_TITLE,

	PANEL_STYLE_DAWN,
	PANEL_STYLE_DAWNTOP,
	PANEL_STYLE_DAWNBOTTOM,

	PANEL_STYLE_MAIN,
	PANEL_STYLE_MAIN_BLACK25,
	PANEL_STYLE_MAIN_BLACK50,
	PANEL_STYLE_MAIN_WHITE,
	PANEL_STYLE_MAIN_WHITETAB,
	PANEL_STYLE_MAIN_TAN,
	PANEL_STYLE_MAIN_TAN15,
	PANEL_STYLE_MAIN_TANL,
	PANEL_STYLE_MAIN_TANR,
	PANEL_STYLE_MAIN_TANT,
	PANEL_STYLE_MAIN_TANB,
	PANEL_STYLE_MAIN_BOTTOMBAR,
	PANEL_STYLE_MAIN_SELECT,
};

enum DllExport ButtonStyles								// Exposed to Python
{
	BUTTON_STYLE_STANDARD,
	BUTTON_STYLE_ETCHED,
	BUTTON_STYLE_FLAT,
	BUTTON_STYLE_IMAGE,
	BUTTON_STYLE_LABEL,
	BUTTON_STYLE_LINK,
	BUTTON_STYLE_SQUARE,
	BUTTON_STYLE_TOOL,
	BUTTON_STYLE_DEFAULT,

	// Civ specific styles
	BUTTON_STYLE_CIRCLE,
	BUTTON_STYLE_CITY_B01,
	BUTTON_STYLE_CITY_B02TL,
	BUTTON_STYLE_CITY_B02TR,
	BUTTON_STYLE_CITY_B02BL,
	BUTTON_STYLE_CITY_B02BR,
	BUTTON_STYLE_CITY_B03TL,
	BUTTON_STYLE_CITY_B03TC,
	BUTTON_STYLE_CITY_B03TR,
	BUTTON_STYLE_CITY_B03BL,
	BUTTON_STYLE_CITY_B03BC,
	BUTTON_STYLE_CITY_B03BR,
	BUTTON_STYLE_CITY_FLAT,
	BUTTON_STYLE_CITY_PLUS,
	BUTTON_STYLE_CITY_MINUS,

	BUTTON_STYLE_ARROW_LEFT,
	BUTTON_STYLE_ARROW_RIGHT
};

enum DllExport TableStyles								// Exposed to Python
{
	TABLE_STYLE_STANDARD,
	TABLE_STYLE_EMPTY,
	TABLE_STYLE_ALTEMPTY,
	TABLE_STYLE_CITY,
	TABLE_STYLE_EMPTYSELECTINACTIVE,
	TABLE_STYLE_ALTDEFAULT,
	TABLE_STYLE_STAGINGROOM
};

enum DllExport EventContextTypes					// Exposed to Python
{
	NO_EVENTCONTEXT = -1,

	EVENTCONTEXT_SELF,
	EVENTCONTEXT_ALL,
};

enum DllExport CivLoginStates
{
	NO_CIV_LOGIN = -1,

	LOGIN_CIV_OK,
	LOGIN_CIV_BAD_PWD,
	LOGIN_CIV_TAKEN,
	LOGIN_CIV_HAS_ID,
};
 
enum DllExport VersionTypes
{
	NO_VERSIONTYPE = -1,

	VERSIONTYPE_EXE,
	VERSIONTYPE_DLL,
	VERSIONTYPE_SHADERS,
	VERSIONTYPE_PYTHON,
	VERSIONTYPE_XML,
};

enum DllExport VoteResultTypes
{
	VOTERESULT_MAJORITY,
	VOTERESULT_UNANIMOUS,
};

enum DllExport VoteStatusTypes
{
	NO_VOTESTATUS = -1, 

	VOTESTATUS_TIED = -2,
	VOTESTATUS_UNDECIDED = -3,
	VOTESTATUS_INCOMPLETE = -4
};

// Tab Group in Options Menu
enum DllExport TabGroupTypes				// Exposed to Python
{
	NO_TABGROUP = -1,

	TABGROUP_GAME,
	TABGROUP_INPUT,
	TABGROUP_GRAPHICS,
	TABGROUP_AUDIO,
	TABGROUP_CLOCK,

	NUM_TABGROUPS
};

enum DllExport ReplayMessageTypes		// Exposed to Python
{
	NO_REPLAY_MESSAGE = -1,

	REPLAY_MESSAGE_MAJOR_EVENT,
	REPLAY_MESSAGE_CITY_FOUNDED,
	REPLAY_MESSAGE_PLOT_OWNER_CHANGE,

	NUM_REPLAY_MESSAGE_TYPES
};

/*------------------------------------------------------------------------------------
Enum:		EAudioTag
Purpose:	To enumerate all of the tag strings loaded from the csv or xml files
------------------------------------------------------------------------------------*/
enum DllExport AudioTag							// Exposed to Python
{
	AUDIOTAG_NONE = -1,
	AUDIOTAG_SOUNDID,
	AUDIOTAG_CONTEXTID,
	AUDIOTAG_SOUNDTYPE,
	AUDIOTAG_2DSCRIPT,
	AUDIOTAG_3DSCRIPT,
	AUDIOTAG_SOUNDSCAPE,
	AUDIOTAG_POSITION,
	AUDIOTAG_SCRIPTTYPE,
	AUDIOTAG_LOADTYPE,
	AUDIOTAG_COUNT,
};

enum DllExport CivilopediaPageTypes		// Exposed to Python
{
	NO_CIVILOPEDIA_PAGE = -1,

	CIVILOPEDIA_PAGE_TECH,
	CIVILOPEDIA_PAGE_UNIT,
	CIVILOPEDIA_PAGE_BUILDING,
	CIVILOPEDIA_PAGE_WONDER,
	CIVILOPEDIA_PAGE_TERRAIN,
	CIVILOPEDIA_PAGE_FEATURE,
	CIVILOPEDIA_PAGE_BONUS,
	CIVILOPEDIA_PAGE_IMPROVEMENT,
	CIVILOPEDIA_PAGE_SPECIALIST,
	CIVILOPEDIA_PAGE_PROMOTION,
	CIVILOPEDIA_PAGE_UNIT_GROUP,
	CIVILOPEDIA_PAGE_CIV,
	CIVILOPEDIA_PAGE_LEADER,
	CIVILOPEDIA_PAGE_RELIGION,
	CIVILOPEDIA_PAGE_CIVIC,
	CIVILOPEDIA_PAGE_PROJECT,
	CIVILOPEDIA_PAGE_CONCEPT,
	CIVILOPEDIA_PAGE_HINTS,

	NUM_CIVILOPEDIA_PAGE_TYPES
};

enum DllExport ActionSubTypes					// Exposed to Python
{
	NO_ACTIONSUBTYPE = -1,

	ACTIONSUBTYPE_INTERFACEMODE,
	ACTIONSUBTYPE_COMMAND,
	ACTIONSUBTYPE_BUILD,
	ACTIONSUBTYPE_PROMOTION,
	ACTIONSUBTYPE_UNIT,
	ACTIONSUBTYPE_RELIGION,
	ACTIONSUBTYPE_SPECIALIST,
	ACTIONSUBTYPE_BUILDING,
	ACTIONSUBTYPE_CONTROL,
	ACTIONSUBTYPE_AUTOMATE,
	ACTIONSUBTYPE_MISSION,

	NUM_ACTIONSUBTYPES
};

enum DllExport GameMessageTypes				// Exposed to Python
{
	GAMEMESSAGE_NETWORK_READY,
	GAMEMESSAGE_SAVE_GAME_FLAG,
	GAMEMESSAGE_SAVE_FLAG_ACK,
	GAMEMESSAGE_VERIFY_VERSION,
	GAMEMESSAGE_VERSION_NACK,
	GAMEMESSAGE_VERSION_WARNING,
	GAMEMESSAGE_GAME_TYPE,
	GAMEMESSAGE_ID_ASSIGNMENT,
	GAMEMESSAGE_FILE_INFO,
	GAMEMESSAGE_PICK_YOUR_CIV,
	GAMEMESSAGE_CIV_CHOICE,
	GAMEMESSAGE_CONFIRM_CIV_CLAIM, 
	GAMEMESSAGE_CLAIM_INFO,
	GAMEMESSAGE_CIV_CHOICE_ACK,
	GAMEMESSAGE_CIV_CHOICE_NACK,
	GAMEMESSAGE_CIV_CHOSEN,
	GAMEMESSAGE_INTERIM_NOTICE,
	GAMEMESSAGE_INIT_INFO,
	GAMEMESSAGE_MAPSCRIPT_CHECK,
	GAMEMESSAGE_MAPSCRIPT_ACK,
	GAMEMESSAGE_LOAD_GAME,
	GAMEMESSAGE_PLAYER_ID,
	GAMEMESSAGE_SLOT_REASSIGNMENT,
	GAMEMESSAGE_PLAYER_INFO,
	GAMEMESSAGE_GAME_INFO,
	GAMEMESSAGE_REASSIGN_PLAYER,
	GAMEMESSAGE_PITBOSS_INFO,
	GAMEMESSAGE_LAUNCHING_INFO,
	GAMEMESSAGE_INIT_GAME,
	GAMEMESSAGE_INIT_PLAYERS,
	GAMEMESSAGE_AUTH_REQUEST,
	GAMEMESSAGE_AUTH_RESPONSE,
	GAMEMESSAGE_SYNCH_START,
	GAMEMESSAGE_PLAYER_OPTION,
	GAMEMESSAGE_EXTENDED_GAME,
	GAMEMESSAGE_AUTO_MOVES,
	GAMEMESSAGE_TURN_COMPLETE,
	GAMEMESSAGE_JOIN_GROUP,
	GAMEMESSAGE_PUSH_MISSION,
	GAMEMESSAGE_AUTO_MISSION,
	GAMEMESSAGE_DO_COMMAND,
	GAMEMESSAGE_PUSH_ORDER,
	GAMEMESSAGE_POP_ORDER,
	GAMEMESSAGE_DO_TASK,
	GAMEMESSAGE_RESEARCH,
	GAMEMESSAGE_PERCENT_CHANGE,
	GAMEMESSAGE_CONVERT,
	GAMEMESSAGE_CHAT,
	GAMEMESSAGE_PING,
	GAMEMESSAGE_SIGN,
	GAMEMESSAGE_LINE_ENTITY,
	GAMEMESSAGE_SIGN_DELETE,
	GAMEMESSAGE_LINE_ENTITY_DELETE,
	GAMEMESSAGE_PAUSE,
	GAMEMESSAGE_MP_KICK,
	GAMEMESSAGE_MP_RETIRE,
	GAMEMESSAGE_CLOSE_CONNECTION,
	GAMEMESSAGE_NEVER_JOINED,
	GAMEMESSAGE_MP_DROP_INIT,
	GAMEMESSAGE_MP_DROP_VOTE,
	GAMEMESSAGE_MP_DROP_UPDATE,
	GAMEMESSAGE_MP_DROP_RESULT,
	GAMEMESSAGE_MP_DROP_SAVE,
	GAMEMESSAGE_TOGGLE_TRADE,
	GAMEMESSAGE_IMPLEMENT_OFFER,
	GAMEMESSAGE_CHANGE_WAR,
	GAMEMESSAGE_CHOOSE_ELECTION,
	GAMEMESSAGE_DIPLO_VOTE,
	GAMEMESSAGE_APPLY_EVENT,
	GAMEMESSAGE_CONTACT_CIV,
	GAMEMESSAGE_DIPLO_CHAT,
	GAMEMESSAGE_SEND_OFFER,
	GAMEMESSAGE_DIPLO_EVENT,
	GAMEMESSAGE_RENEGOTIATE,
	GAMEMESSAGE_RENEGOTIATE_ITEM,
	GAMEMESSAGE_EXIT_TRADE,
	GAMEMESSAGE_KILL_DEAL,
	GAMEMESSAGE_SAVE_GAME,
	GAMEMESSAGE_UPDATE_CIVICS,
	GAMEMESSAGE_CLEAR_TABLE,
	GAMEMESSAGE_POPUP_PROCESSED,
	GAMEMESSAGE_DIPLOMACY_PROCESSED,
	GAMEMESSAGE_HOT_JOIN_NOTICE,
	GAMEMESSAGE_HOT_DROP_NOTICE,
	GAMEMESSAGE_DIPLOMACY,
};

enum DllExport PopupControlLayout		// Exposed to Python
{
	POPUP_LAYOUT_LEFT,
	POPUP_LAYOUT_CENTER,
	POPUP_LAYOUT_RIGHT,
	POPUP_LAYOUT_STRETCH,

	POPUP_LAYOUT_NUMLAYOUTS
};

enum DllExport JustificationTypes		// Exposed to Python
{
	DLL_FONT_LEFT_JUSTIFY = 1<<0,
	DLL_FONT_RIGHT_JUSTIFY = 1<<1,
	DLL_FONT_CENTER_JUSTIFY = 1<<2,
	DLL_FONT_CENTER_VERTICALLY = 1<<3,
	DLL_FONT_ADDITIVE = 1<<4,
};

enum DllExport ToolTipAlignTypes		// Exposed to Python
{
	TOOLTIP_TOP_LEFT,
	TOOLTIP_TOP_INLEFT,
	TOOLTIP_TOP_CENTER,
	TOOLTIP_TOP_INRIGHT,
	TOOLTIP_TOP_RIGHT,

	TOOLTIP_INTOP_RIGHT,
	TOOLTIP_CENTER_RIGHT,
	TOOLTIP_INBOTTOM_RIGHT,

	TOOLTIP_BOTTOM_RIGHT,
	TOOLTIP_BOTTOM_INRIGHT,
	TOOLTIP_BOTTOM_CENTER,
	TOOLTIP_BOTTOM_INLEFT,
	TOOLTIP_BOTTOM_LEFT,

	TOOLTIP_INBOTTOM_LEFT,
	TOOLTIP_CENTER_LEFT,
	TOOLTIP_INTOP_LEFT,
};

enum DllExport ActivationTypes			// Exposed to Python
{
	ACTIVATE_NORMAL,
	ACTIVATE_CHILDFOCUS,
	ACTIVATE_MIMICPARENT,
	ACTIVATE_MIMICPARENTFOCUS,
};

enum DllExport HitTestTypes					// Exposed to Python
{
	HITTEST_DEFAULT,
	HITTEST_ON,
	HITTEST_SOLID,
	HITTEST_CHILDREN,
	HITTEST_NOHIT,
};

enum DllExport GraphicLevelTypes		// Exposed to Python
{
	GRAPHICLEVEL_HIGH,
	GRAPHICLEVEL_MEDIUM,
	GRAPHICLEVEL_LOW,
	GRAPHICLEVEL_CURRENT,

	NUM_GRAPHICLEVELS
};

#endif	// CVENUMS_h
